/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.IRemoteConnection;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentNotificationHandler;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.NotificationDispatcher;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class RemoteInstrument {
    private IRemoteConnection m_connection;
    private RcvThread m_receiver;
    private byte[] m_recvBuffer;
    private final int RECV_MAX = 256;
    private StringBuffer m_respBuffer;
    private InstrumentResponse m_resp;
    private boolean m_echoComplete;
    private boolean m_respComplete;
    private boolean m_promptComplete;
    private NotificationDispatcher m_notDispatcher;
    private Vector<InstrumentNotificationHandler> m_notHandlers;
    private final int DEFAULT_TIMEOUT_MS = 10000;
    private boolean m_debug = false;
    private IQDConsole m_console;

    public RemoteInstrument(IRemoteConnection connection, IQDConsole console) {
        this.m_connection = connection;
        this.m_console = console;
        this.m_recvBuffer = new byte[256];
        this.m_respComplete = true;
        this.m_promptComplete = true;
        this.m_resp = new InstrumentResponse("", false);
        this.m_respBuffer = new StringBuffer(1024);
        this.m_notHandlers = new Vector();
        this.m_notDispatcher = null;
    }

    public void connect() throws InstrumentException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connection == null) {
            throw new InstrumentException("No Connection Context Found.");
        }
        try {
            this.m_connection.connect();
        }
        catch (Exception e) {
            this.printMsg(e.getMessage());
            throw new InstrumentException(e.getMessage());
        }
        this.printMsg("Connected");
        this.m_notDispatcher = new NotificationDispatcher(this.m_notHandlers);
        this.m_notDispatcher.start();
        this.m_receiver = new RcvThread();
        this.m_receiver.start();
    }

    public boolean isConnected() {
        if (this.m_connection != null) {
            return this.m_connection.isConnected();
        }
        return false;
    }

    public IRemoteConnection getConnection() {
        return this.m_connection;
    }

    public String getErrorMessage() {
        if (this.m_connection != null) {
            return this.m_connection.getErrorMessage();
        }
        return "";
    }

    public void setConnection(IRemoteConnection con) {
        if (this.m_connection != null && this.m_connection.isConnected()) {
            this.disconnect();
        }
        this.m_connection = con;
    }

    public void setConsole(IQDConsole console) {
        this.m_console = console;
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.m_connection.disconnect();
            this.m_receiver.join();
            this.m_notDispatcher = null;
        }
        catch (Exception e) {
            this.printMsg(e.getMessage());
            return;
        }
        this.printMsg("Disconnected");
    }

    public void addNotificationHandler(InstrumentNotificationHandler handler) {
        this.m_notHandlers.add(handler);
    }

    public InstrumentResponse sendCmdAltChannel(String cmd, int timeout) {
        IRemoteConnection con = this.m_connection.getAlternateChannel();
        if (con == null) {
            String txt = "Alternate channel not available";
            this.printMsg(txt);
            return new InstrumentResponse(txt, true);
        }
        RemoteInstrument instr = new RemoteInstrument(con, this.m_console);
        try {
            instr.connect();
        }
        catch (InstrumentException ex) {
            String txt = "Can not establish alternate instrument connection: " + ex.getMessage();
            this.printMsg(txt);
            return new InstrumentResponse(txt, true);
        }
        InstrumentResponse resp = instr.send(cmd, timeout);
        instr.disconnect();
        return resp;
    }

    public synchronized InstrumentResponse sendCmd(String cmd) {
        return this.sendCmd(cmd, 0);
    }

    public synchronized InstrumentResponse sendCmd(String cmd, int timeOut) {
        if (!this.isConnected()) {
            this.printMsg("ERROR: Not Connected!");
            return new InstrumentResponse("ERROR: Not Connected", true);
        }
        return this.send(cmd, timeOut);
    }

    protected void printMsg(String msg) {
        if (this.m_console != null) {
            this.m_console.println(msg);
        }
    }

    private InstrumentResponse send(String cmd, int timeout) {
        int cnt = 0;
        try {
            this.clearResponse();
            OutputStream os = this.m_connection.getOutputStream();
            if (this.m_debug) {
                System.out.println("S-->: " + cmd);
            }
            this.m_echoComplete = !this.m_connection.isEchoing();
            this.m_promptComplete = true;
            String cmdPlusTerm = String.valueOf(cmd) + "\r\n";
            os.write(cmdPlusTerm.getBytes());
            int maxTics = timeout == 0 ? 200 : timeout / 50;
            while (!this.m_respComplete) {
                Thread.sleep(50L);
                if (++cnt <= maxTics) continue;
                this.printMsg("ERROR: Send Timeout");
                return new InstrumentResponse("ERROR: Send Timeout", true);
            }
        }
        catch (Exception e) {
            this.printMsg("ERROR: Send Exception " + e.getMessage());
            return new InstrumentResponse("ERROR: Send Exception " + e.getMessage(), true);
        }
        return this.m_resp;
    }

    private void clearResponse() {
        this.m_respComplete = false;
        this.m_echoComplete = false;
    }

    public void receive() {
        try {
            InputStream is = this.m_connection.getInputStream();
            while (this.m_connection.isConnected()) {
                int cnt = is.read(this.m_recvBuffer);
                if (cnt < 0) {
                    this.m_connection.disconnect();
                    this.m_notDispatcher.deactivate();
                    this.m_notDispatcher.join();
                    break;
                }
                if (cnt > 0) {
                    String txt = new String(this.m_recvBuffer, 0, cnt);
                    if (this.m_debug) {
                        System.out.println("R-->: " + txt);
                    }
                    this.m_respBuffer.append(txt);
                    this.ProcessBuffer();
                }
                Thread.sleep(50L);
            }
            this.printMsg("Disconnected");
        }
        catch (Exception e) {
            this.printMsg("ERROR RCV: " + e.getMessage());
        }
    }

    private void ProcessBuffer() {
        String eol = this.m_echoComplete ? (this.m_promptComplete ? this.m_connection.getEndOfResponse() : this.m_connection.getEndOfPrompt()) : "\r\n";
        int index = this.m_respBuffer.indexOf(eol);
        while (index >= 0) {
            String msg = this.m_respBuffer.substring(0, index);
            this.m_respBuffer.delete(0, index + eol.length());
            if (msg.indexOf(">>:") == 0) {
                String notif = msg.substring(3);
                this.m_notDispatcher.dispatch(notif);
            } else if (msg.indexOf("**:") == 0) {
                this.m_resp = new InstrumentResponse(msg.substring(3), true);
                this.m_respComplete = true;
                if (this.m_debug) {
                    System.out.println("  ERR: " + this.m_resp.getResponse());
                }
            } else if (this.m_echoComplete) {
                if (!this.m_promptComplete) {
                    this.m_promptComplete = true;
                    this.m_respComplete = true;
                } else {
                    this.m_resp = new InstrumentResponse(msg, false);
                    if (this.m_debug) {
                        System.out.println("  RSP: " + this.m_resp.getResponse());
                    }
                    if (this.m_connection.getEndOfPrompt().length() == 0) {
                        this.m_respComplete = true;
                    } else {
                        this.m_promptComplete = false;
                    }
                }
            } else {
                this.m_echoComplete = true;
            }
            eol = this.m_echoComplete ? (this.m_promptComplete ? this.m_connection.getEndOfResponse() : this.m_connection.getEndOfPrompt()) : "\r\n";
            index = this.m_respBuffer.indexOf(eol);
        }
    }

    private class RcvThread
    extends Thread {
        public RcvThread() {
            this.setDaemon(true);
        }

        public void run() {
            RemoteInstrument.this.receive();
        }
    }
}

